/************************************************************************************************************\

Module Name:    LStatus.h

Description:    .

References:     None.

    Copyright (c) 2010, Matrox Graphics Inc.
    All Rights Reserved.

\************************************************************************************************************/

#ifndef INC_LSTATUS_H
#define INC_LSTATUS_H

// -----------------------------------------------------------------------------------------------------------
//                                   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------
typedef enum
{
    // Error codes specific to H.264
    LStatus_SEIOVERSIZE                         = -108,  // The Sei Rbsp exceeds the maximum supported by the driver.
    LStatus_SEQUENCE_RESET                      = -107,  // ResetSequence signal has been completed in the codec
                                                         // pipeline
    LStatus_DISORDERED_RELEASE_COUNT            = -106,  // Release count is not correctly incremented
    LStatus_CRITICAL_END_OF_STREAM              = -105,  // Critical stream failure generating an end of stream
    LStatus_STREAM_NOT_INITIALIZED              = -104,  // Stream initialization is not yet completed
    LStatus_INCOMPLETE_COMMAND                  = -103,  // The command has been partially executed
    LStatus_REORDERED_SEQUENCE_PENDING          = -102,  // The function can't apply the new info because
                                                         //  it has been sent in the middle of a reordered
                                                         //  sequence.
    LStatus_END_OF_STREAM                       = -101,  // There is no more pictures or NALU available
                                                         //  for the current stream
    LStatus_INFO_NOT_AVAILABLE                  = -100,  // There is currently no information for this
                                                         //  stream info type

    // Standard codes
    LStatus_TEMPORARY_LACK_OF_RESOURCES         = -16,   // Pending destruction, more memory will be available soon.
    LStatus_HARDWARE_MALFUNCTION                = -15,   // System problems have been detected. Re-initialization is required.
    LStatus_CONNECTION_LOST                     = -14,   // The server lost the connection
    LStatus_COMMAND_PENDING                     = -13,   // The context destruction cannot be done because one
                                                         // or more command related to this context are still
                                                         // pending (not terminated).
    LStatus_CANCELED                            = -12,   // The event will never arrive.
    LStatus_DEVICETHREAD_COMMAND_QUEUE_FULL     = -11,   // The command can't be pushed on the device thread command queue actually because it is full
    LStatus_UNSUPPORTED                         = -10,   // The requested operation or an argument is not supported
    LStatus_ACCESS_DENIED                       = -9,    // Resource are in use and cannot be accessed now
    LStatus_RESOURCES_BUSY                      = -8,    // Resource are in use and cannot be accessed now
    LStatus_OUT_OF_RESOURCES                    = -7,    // Resources needed are not available
    LStatus_OUT_OF_MEMORY                       = -6,    // no more memory available
    LStatus_NO_DATA                             = -5,    // No data available
    LStatus_NO_MORE_DATA                        = -4,    // No more data in an enumeration
    LStatus_TIMEOUT                             = -3,    // Timeout reached
    LStatus_INVALID_PARAM                       = -2,    // Invalid parameters.
    LStatus_FAIL                                = -1,    // Generic fail
    LStatus_OK                                  =  0,    // Success
    LStatus_NOT_OPTIMAL                         =  1,    // Not optimal.
    LStatus_NOTHING_DONE                        =  2,    // Nothing to do

    // SUCCESS codes specific to H.264
    LStatus_OK_INCOMPLETE_REORDERED_SEQUENCE    = 102,  // The command is incomplete because it is in
                                                        // the middle of a reordered sequence.
                                                        // The pictures are accumulated until we have
                                                        // all pictures available for the reordering.
    LStatus_OK_MISSING_FIRST_SPS                = 103,  // Parsing continue without decoding until a
                                                        // first SPS is met in the bytestream.
    LStatus_OK_STREAM_NOT_LOWLATENCY            = 104,  // Stream contains frame reordering, decoding continues
                                                        // in normal mode (not low latency mode).

} LStatus;



#define LSTATUS_IS_SUCCESS(iErrorCode)              ((iErrorCode) >=0)
#define LSTATUS_IS_FAIL(iErrorCode)                 ((iErrorCode) < 0)


#endif  // #ifndef INC_LSTATUS_H
